clear all
clc
close all

load AALabData

Y=Action;
n=length(row); %number of games

%% Uniform NE

% Randomize prediction over NE
Q=1000; % number of iterations
Acc=zeros(1,Q);
for q=1:Q
    accne=zeros(1,n);
    for i=1:n
        ne=find(IndNE{i});
        m=length(ne);
        if m>0
            r=randi(m);
            accne(i)=logical(Y(i)==ne(r));
            clear ne
        else
            r=randi(3);
            accne(i)=logical(Y(i)==r);
        end
    end
    AccNE(q)=mean(accne);
end

'Accuracy Uniform-NE'
mean(AccNE)

'Standard Error'
sqrt(var(AccNE))

%% Level 1

% Find Level 1 Prediction
lev1=zeros(1,n);
for i=1:n
    sumrow=sum(row{i},2);
    lev1(i)=find(sumrow==max(sumrow));
end

Q=1000; %number of iterations
acclev1=zeros(1,Q);
for q=1:Q
    [resampleY,ind]=datasample(Y,n);
    resamplelev1=lev1(ind);
    acclev1(q)=length(find(resamplelev1'==resampleY))/length(resampleY);
end

'Accuracy Level-1'
mean(acclev1)

'Level-1 SE'
sqrt(var(acclev1))

%% Cognitive Hierarchy

levR{1}=1/3*ones(1,3);
levC{1}=1/3*ones(1,3);

tau=[0.5 0.6 0.7 0.8 0.9 1 1.1 1.2 1.3 1.4 1.5];

K=10;
c = cvpartition(n,'KFold',K);
besttau=cell(1,K);
acc=zeros(1,K);
for k=1:K
    
    % Training Data
    
    train=find(c.training(k));
    trainY=Y(train,:);
    trainRow=row(train);
    trainCol=column(train);
    
    besttau{k}=CH(tau,trainRow,trainCol,trainY);
    
    % Test Data
    
    test=find(c.test(k));
    testY=Y(test,:);
    testRow=row(test);
    testCol=column(test);
    
    T=besttau{k};
    acc(k)=CHfixedtau(tau(T(1)),testRow,testCol,testY);
end

'Best Tau'
besttau{1} %vary to see best-fit estimates of tau in different folds of CV

'PCHM Accuracy'
mean(acc)

'PCHM SE'
sqrt(var(acc))/sqrt(K)


%% Predict if Pareto-Dominant NE

ind=[3,15,27];
FeatParetoNE=FeaturesAct(:,ind);

Q=50;
ErrParetoNE=zeros(1,Q);
for q=1:50
    error=zeros(1,n);
    for i=1:n
        paretoNE=find(FeatParetoNE(i,:));
        m=length(paretoNE);
        if m>0
            r=randi(m);
            error(i)=logical(paretoNE(r)~=Y(i));
        else
            r=randi(3);
            error(i)=logical(r~=Y(i));
        end
    end
    ErrParetoNE(q)=mean(error);
end

'Accuracy predicting Pareto NE'
1-mean(ErrParetoNE)

'Standard Error'
sqrt(var(ErrParetoNE))

%% Lexicographic Rule: predict if Pareto-Dominant NE, then Lev1(alpha)

% Find Level 1(alpha) Prediction
alpha=0.625;
lev1R=zeros(1,n);
for i=1:n
    sumrow=sum(row{i}.^alpha,2);
    lev1R(i)=find(sumrow==max(sumrow));
end

error=zeros(1,n);
for i=1:n
    paretoNE=find(FeatParetoNE(i,:));
    m=length(paretoNE);
    if m>0
        r=randi(m);
        error(i)=logical(paretoNE(r)~=Y(i));
    else
        error(i)=logical(lev1R(i)~=Y(i));
    end
end

'Accuracy using Lexicographic Rule'
1-mean(error)



